//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.IO;
using System.CodeDom;
using System.CodeDom.Compiler;

class GenerateCode
{
	public static void HelloWorldCode(CodeDomProvider provider, StreamWriter output)
	{
		// Generowanie kodu
		ICodeGenerator cg = provider.CreateGenerator(output);
		CodeGeneratorOptions op = new CodeGeneratorOptions();

		// Generowanie komentarzy na pocztku funkcji
		CodeCommentStatement comment = new CodeCommentStatement("Kod generujcy Witaj wiecie!");
		cg.GenerateCodeFromStatement(comment, output, op);
		comment = new CodeCommentStatement("Najpierw naley utworzy przestrze nazw.");
		cg.GenerateCodeFromStatement(comment, output, op);

		// Przestrze nazw
		CodeNamespace codeNamespace = new CodeNamespace("HelloWorld");
		// Przestrze nazw
		CodeNamespaceImport import = new CodeNamespaceImport("System");
		codeNamespace.Imports.Add(import);
		// Klasa otrzymuje unikaln nazw
		CodeTypeDeclaration mainClass = new CodeTypeDeclaration("HelloWorldMain");

		// Dodanie klasy do przestrzeni nazw
		codeNamespace.Types.Add(mainClass);

		// Utworzenie funkcji Main
		CodeEntryPointMethod main = new CodeEntryPointMethod();

		CodeParameterDeclarationExpression param = 
			new CodeParameterDeclarationExpression("System.String []", "args");

		comment = new CodeCommentStatement("Wywietlenie powitania w konsoli");
		main.Statements.Add(comment);

		CodeVariableDeclarationStatement variable = new CodeVariableDeclarationStatement(typeof(string), "message", new CodePrimitiveExpression("Hello World!"));
		main.Statements.Add(variable);

		CodeVariableReferenceExpression[] arg = new CodeVariableReferenceExpression[1];
		arg[0] = new CodeVariableReferenceExpression(variable.Name);
		CodeMethodReferenceExpression type = new CodeMethodReferenceExpression();
		type.MethodName = "Console";
		CodeMethodInvokeExpression methodCall = new CodeMethodInvokeExpression(type,"WriteLine",arg);
		main.Statements.Add(methodCall);

		mainClass.Members.Add(main);

		cg.GenerateCodeFromNamespace(codeNamespace, output, op);

	}
	public static void CompileAndExecute(CodeDomProvider provider, string filename, string target)
	{
		// Uycie interfejsu CodeProvider
		CompilerParameters param = new CompilerParameters(null, target, true);
		param.GenerateExecutable = true;
		ICodeCompiler cc = provider.CreateCompiler();
		CompilerResults cr = cc.CompileAssemblyFromFile(param, filename);
		System.Collections.Specialized.StringCollection output = cr.Output;
		foreach(string s in output)
		{
			Console.WriteLine(s);
		}

		if(cr.Errors.Count != 0)
		{
			CompilerErrorCollection es = cr.Errors;
			foreach(System.CodeDom.Compiler.CompilerError e in es)
			{
				Console.WriteLine(e.ToString());
			}
		}
		else
		{
			// Ustawienie ApplicationBase na aktualny katalog
			AppDomainSetup info = new AppDomainSetup();
			info.ApplicationBase = "file:\\\\" + System.Environment.CurrentDirectory;
			// Utworzenie domeny aplikacji z pustym dowodem
			AppDomain dom = AppDomain.CreateDomain("HelloWorld", null, info);
			dom.ExecuteAssembly(target);
			// Oczyszczenie poprzez usunicie domeny aplikacji z pamici
			AppDomain.Unload(dom);  
		}
	}
}
